<?

namespace view;

use DOMWrap\Document;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Users extends View
{

    public $SingularName = 'کاربر';

    public function main(Document &$document)
    {
        $role = UserObject::instance()->getRole();
        if ($role == "AdminRole"){
            $edit = true;
        }else{
            $edit = false;
        }
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'),
                                                                    HtmlTags::Th('اشتراک'),
                                                                    HtmlTags::Th('کد کارت باشگاه'),
                                                                    HtmlTags::Th('تاریخ عضویت'),

                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(

                                                                $this->show([
                                                                    function ($row) {
                                                                        return show_user_name($row->user_id);

                                                                    },
                                                                    'plan_id'=>function($plan){
                                                                        return$plan? \model\Plans::get($plan)->plan_name : "بدون اشتراک";
                                                                    },
                                                                    'user_plan_code',
                                                                    'created_at'=>function($item){
                                                                     return jdate("H:i   ---    Y/m/d  ", strtotime($item));
                                                                    }
                                                                ],true,$edit,false,true)
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات حساب کاربری') .
                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('نام').
                                        $this->Html()->Input('user_name').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('نام خانوادگی').
                                        $this->Html()->Input('user_lastname').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('موبایل').
                                        $this->Html()->Input('user_mobile').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('پسورد').
                                        $this->Html()->Password('user_password').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(12).
                                        $this->Html()->Label('موجودی').
                                        $this->Html()->Price('user_credit').
                                        $this->Html()->FormGroupEnd().

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات اشتراک خریداری شده') .

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('اشتراک').
                                        $this->Html()->Input('plan_id','plan_id').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('تاریخ فعالسازی').
                                        $this->Html()->PersianDate('plan_activated_at','plan_activated_at').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('تاریخ انقضا').
                                        $this->Html()->PersianDate('plan_expired_at','plan_expired_at').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(3).
                                        $this->Html()->Label('کد کارت باشگاه').
                                        $this->Html()->Input('user_plan_code').
                                        $this->Html()->FormGroupEnd().

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات هویتی') .



                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('کد ملی').
                                        $this->Html()->Input('user_national_code').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('ایمیل').
                                        $this->Html()->Email('user_email').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('کد پستی').
                                        $this->Html()->Number('user_postal_code').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('تصویر 3*4').
                                        $this->Html()->ImageInput('user_image').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('شماره شبا').
                                        $this->Html()->Number('user_sheba').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(12).
                                        $this->Html()->Label('آدرس').
                                        $this->Html()->TextArea('user_address').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }
    public function editForm()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات حساب کاربری') .
                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('نام').
                                        $this->Html()->Input('user_name').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('نام خانوادگی').
                                        $this->Html()->Input('user_lastname').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('موبایل').
                                        $this->Html()->Input('user_mobile').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('پسورد').
                                        $this->Html()->Password('user_password').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(12).
                                        $this->Html()->Label('موجودی').
                                        $this->Html()->Price('user_credit').
                                        $this->Html()->FormGroupEnd().

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات اشتراک خریداری شده') .

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('اشتراک').
                                        $this->Html()->Select('plan_id','plan_id',\model\Plans::toOption(),false,false,true).
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('کد کارت باشگاه').
                                        $this->Html()->Input('user_plan_code','user_plan_code','',false,true).
                                        $this->Html()->FormGroupEnd().

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('اطلاعات هویتی') .



                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('کد ملی').
                                        $this->Html()->Input('user_national_code').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(6).
                                        $this->Html()->Label('ایمیل').
                                        $this->Html()->Email('user_email').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('کد پستی').
                                        $this->Html()->Number('user_postal_code').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('تصویر 3*4').
                                        $this->Html()->ImageInput('user_image').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(4).
                                        $this->Html()->Label('شماره شبا').
                                        $this->Html()->Number('user_sheba').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->FormGroupStart(12).
                                        $this->Html()->Label('آدرس').
                                        $this->Html()->TextArea('user_address').
                                        $this->Html()->FormGroupEnd().

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }


    public function authenticate(Document &$document)
    {

        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refresh()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نام'),
                                                                    HtmlTags::Th('اشتراک'),
                                                                    HtmlTags::Th('کد کارت باشگاه'),
                                                                    HtmlTags::Th('تاریخ عضویت'),

                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(

                                                                $this->show([
                                                                    function ($row) {
                                                                        return show_user_name($row->user_id);

                                                                    },
                                                                    'plan_id'=>function($plan){
                                                                        return$plan? \model\Plans::get($plan)->plan_name : "بدون اشتراک";
                                                                    },
                                                                    'user_plan_code',
                                                                    'created_at'=>function($item){
                                                                        return jdate("H:i   ---    Y/m/d  ", strtotime($item));
                                                                    }
                                                                ],false,false,false,true,function ($row){
                                                                        return HtmlTags::A('.btn.btn-success.p-2.verifyUser')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check()))
                                                                                ->Data_('id', $row->user_id)
                                                                                ->Data_('status', 1)
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('تایید کاربر')." ".
                                                                         HtmlTags::A('.btn.btn-danger.p-2.verifyUser')->Content(
                                                                                HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times()))
                                                                                ->Data_('id', $row->user_id)
                                                                                ->Data_('status', 0)
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('عدم تایید کاربر')." ";
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }




    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->editForm();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        