<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ContactUsMigration extends Migratable {
    const modelName = 'ContactUs';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('contact_u_id');
			$blueprint->VarChar('contact_us_title')->Len(150);
			$blueprint->Text('contact_us_description');
			$blueprint->VarChar('contact_us_image')->Len(150);
			$blueprint->VarChar('contact_us_faq_image')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
