<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class aboutUsMigration extends Migratable {
    const modelName = 'aboutUs';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('bout_u_id');
			$blueprint->VarChar('about_us_title')->Len(150);
			$blueprint->VarChar('about_us_image')->Len(150);
			$blueprint->Text('about_us_description');
			$blueprint->VarChar('about_us_second_title')->Len(150);
			$blueprint->VarChar('about_us_second_image')->Len(150);
			$blueprint->Text('about_us_second_description');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
