<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class UserCoursesMigration extends Migratable {
    const modelName = 'UserCourses';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('user_course_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('course_id')->Len(150);
			$blueprint->Int('user_course_price')->Len(150);
			$blueprint->Int('user_course_installment_yes_no')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
