<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CommentsMigration extends Migratable {
    const modelName = 'Comments';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('comment_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('reservation_id')->Len(150);
			$blueprint->Text('comment_text');
			$blueprint->VarChar('comment_good_points')->Len(150);
			$blueprint->VarChar('comment_bad_points')->Len(150);
			$blueprint->Int('comment_score')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
