<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class SettingsEntity extends EntityScheme
{
    public $setting_id;
    /**
     * شماره تماس
     **/
    public $tel;
    /**
     * آدرس ایمیل
     **/
    public $email;
    /**
     * نسخه اندروید
     **/
    public $android;
    /**
     * نسخه IOS
     **/
    public $ios;
    public $working_days;
    public $working_hours;
    public $referral_reward_percent;
    public $minimum_withdraw;
    public $footer_title;
    public $footer_text;
    public $license_icon1;
    public $license_icon2;
    public $license_icon3;
    public $license_link1;
    public $license_link2;
    public $license_link3;

    public function model()
    {
        return new \model\Settings();
    }

    public function footerApiFormat()
    {
        $socials = \model\Socials::Db()->get()->map(function (SocialsEntity $social){
            return $social->apiFormat();
        });
        $licenses = \model\Licenses::Db()->get()->map(function (LicensesEntity $license){
            return $license->apiFormat();
        });


        return [
            'tel' => $this->tel,
            'email' => $this->email,
            'android' => $this->android,
            'ios' => $this->ios,
            'socials' => $socials,
            'title' => $this->footer_title,
            'text' => $this->footer_text,
            'licenses' => $licenses,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'setting_id' => 'setting_id',
            'tel' => 'setting_tel',
            'email' => 'setting_email',
            'android' => 'setting_android',
            'ios' => 'setting_ios',
        ];
    }
}
