<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class SecondaryTopBannersEntity extends EntityScheme {
    public $secondary_top_banner_id;
    public $banner_name;
    public $banner;
    public $banner_link;

    public function model() {
        return new \model\SecondaryTopBanners();
    }


    protected function dictionary(): array {
        return [
            'secondary_top_banner_id' => 'secondary_top_banner_id',
            'banner_name' => 'banner_name',
            'banner' => 'banner',
            'banner_link' => 'banner_link',
        ];
    }


    public function apiFormat(): array {
        return [
            'id'     => $this->secondary_top_banner_id,
            'banner' => __IMAGES__ . 'SecondaryTopBanners/' . $this->banner,
            'link'   => $this->banner_link,
            'type'   => 'second',
        ];
    }

}
