<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class MiddleBannersEntity extends EntityScheme {
    public $middle_banner_id;
    /**
     * نام
     **/
    public $banner_name;
    /**
     * لینک
     **/
    public $banner_link;
    /**
     * بنر
     **/
    public $banner;

    public function model() {
        return new \model\MiddleBanners();
    }


    protected function dictionary(): array {
        return [
            'middle_banner_id' => 'middle_banner_id',
            'banner_name' => 'banner_name',
            'banner_link' => 'banner_link',
            'banner' => 'banner',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'     => $this->middle_banner_id,
            'banner' => __IMAGES__ . 'MiddleBanners/' . $this->banner,
            'link'   => $this->banner_link,
            'type'   => 'middle',
        ];
    }

}
