<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class GuildsEntity extends EntityScheme {
    public $guild_id;
    /**
     * نام
     **/
    public $name;
    public $icon;
    public $description;

    public function model() {
        return new \model\Guilds();
    }


    protected function dictionary(): array {
        return [
            'guild_id'    => 'guild_id',
            'name'        => 'guild_name',
            'description' => 'guild_description',
            'icon'        => 'guild_icon',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'          => $this->guild_id,
            'name'        => $this->name,
            'description' => $this->description,
            'icon'        => __IMAGES__ . 'Guilds/' . $this->icon,
        ];
    }

}
