<?php

namespace site\helpers;

use fwJson\Json;
use model\Codes;
use model\Entity\CodesEntity;
use model\Entity\OrdersEntity;
use model\Entity\ProductsEntity;
use model\Entity\UsersEntity;
use model\Orders;
use model\Points;
use model\Products;
use model\Scores;
use model\Transactions;
use model\Users;
use payment\BasePayment;

class ZarinPalPayment extends BasePayment {
    const MerchantCode = '60e9c871-dta2-4e1a-98d9-cfd295344294';
    const Action_url = 'https://www.zarinpal.com/pg/StartPay/';
    const CallBack_url = 'https://anikart.lexaplus.ir/api/callback';
    const Confirm_url = 'https://sandbox.zarinpal.com/pg/v4/payment/verify.json';

    protected $OrderData;

    public function OrderData(Json $json) {
        $this->OrderData = $json;
    }

    public function goToPayment() {
        $this->CreateResNum();
        $user_data = $this->UserModel->get($this->UserData->{$this->UserModel->_key});
        $this->PaymentModel->save($user_data->{$this->UserModel->_key}, $this->_amount, $this->ResNum, $this->OrderData, $this->type, "زرین پال");
        $data = [
            "merchant_id"  => self::MerchantCode,
            "amount"       => $this->_amount >= 50000000 ? 49999999 : $this->_amount,
            "callback_url" => self::CallBack_url,
            "description"  => "پرداخت با کد رهگیری: {$this->ResNum}",
            "metadata"     => [
                "email"  => "info@nahidgolkar.ir",
                "mobile" => str("{$user_data->{$this->UserModel->UserMobile($this->_user_id)}}")->len() > 0 ? "{$user_data->{$this->UserModel->UserMobile($this->_user_id)}}" : "09396329984",
                "resnum" => $this->ResNum,
            ],
        ];
        $jsonData = json_encode($data);
        $ch = curl_init('https://sandbox.zarinpal.com/pg/v4/payment/request.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData),
        ]);
        $result = curl_exec($ch);
        $err = curl_error($ch);
        $result = json_decode($result, true, JSON_PRETTY_PRINT);
        curl_close($ch);
        if ($err) {
            return $err;
        } else {
            if (empty($result['errors'])) {
                if ($result['data']['code'] == 100) {
                    $paymentId = $this->PaymentModel::Db()->orderBy('payment_id', true)->limit(1)->get()->first->payment_id;
                    $this->PaymentModel::edit($paymentId, [
                        $this->PaymentModel->ResNumField() => $result['data']["authority"],
                    ]);
                    return 'https://sandbox.zarinpal.com/pg/StartPay/' . str_replace("\n", "", trim($result['data']["authority"]));
                }
            } else {
                return $result['errors']['message'];
            }
        }
        return "پاسخی از درگاه دریافت نشد";
    }

    public function update($resnum, $refnum): bool {
        $resField = $this->PaymentModel->ResNumField();
        $refField = $this->PaymentModel->RefNumField();
        $paymentData = $this->PaymentModel::Db()->where($resField, $resnum)->get()->first;
        $data = json_decode($paymentData->payment_data);
        $user = Users::get($paymentData->user_id);
        if ($user instanceof UsersEntity) {
            if ($paymentData->payment_type == 'buyPlan') {
                $plan = \model\Plans::get($data->planId);
                $duration = $plan->plan_duration;
                //Points::award($user, Scores::getBy(8), (int)($duration / 30).' ماهه');

                Users::edit($data->userId, [
                    'plan_id'           => $data->planId ?? 0,
                    'plan_activated_at' => time(),
                    'plan_expired_at'   => strtotime("+$duration days", time()),
                ]);
                if (str($user->user_plan_code . '')->len() > 0) {
                    Codes::Db()->where('code', $user->user_plan_code)->where('user_id', $user->user_id)->update([
                                                                                                                    'plan_id' => $data->planId,
                                                                                                                ]);
                } else {
                    $code = Codes::Db()->where('user_id', 'is', null)->orderBy('')->get()->last();
                    if ($code instanceof CodesEntity) {
                        Users::edit($data->userId, [
                            'user_plan_code' => $code->code,
                        ]);
                        Codes::edit($code->code_id, [
                            'plan_id' => $data->planId,
                            'user_id' => $user->user_id,
                        ]);
                    }
                }
                Points::award($user,Scores::getBy(4),"خرید / تمدید اشتراک");
                \SmsHelper::sendSubscriptionSuccess($user->mobile, $plan->name, jdate("Y/m/d", time()), jdate("H:i", time()));
            } else if ($paymentData->payment_type == 'deposit') {
                Users::edit($user->user_id, ['user_credit' => $user->user_credit + $data->amount]);
            }
            //			$user->credit += $paymentData->payment_amount / 10;
            ////            Transactions::create('افزایش اعتبار', $user->user_id, $paymentData->payment_amount / 10, 1);
            //			$user->save();
        }
        return $this->PaymentModel::Db()->where($resField, $resnum)->update([
                                                                                $refField        => $refnum,
                                                                                'payment_status' => 1,
                                                                            ]);
    }

    public function getResult($Authority): array {
        $PaymentData = $this->PaymentModel::getOneFiltered($this->PaymentModel->ResNumField(), $Authority);
        $data = [
            "merchant_id" => \site\helpers\ZarinPalPayment::MerchantCode,
            "authority"   => $Authority,
            "amount"      => $PaymentData->payment_amount,
        ];
        $jsonData = json_encode($data);
        $ch = curl_init(self::Confirm_url);
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData),
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        return [
            $PaymentData,
            json_decode($result, true)
        ];
    }

}
