"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = _default;
exports.messages = exports.ruleName = void 0;

var _lodash = _interopRequireDefault(require("lodash.isregexp"));

var _lodash2 = _interopRequireDefault(require("lodash.isstring"));

var _stylelint = require("stylelint");

var _utils = require("../../utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var ruleName = (0, _utils.namespace)("at-mixin-pattern");
exports.ruleName = ruleName;

var messages = _stylelint.utils.ruleMessages(ruleName, {
  expected: "Expected @mixin name to match specified pattern"
});

exports.messages = messages;

function _default(pattern) {
  return function (root, result) {
    var validOptions = _stylelint.utils.validateOptions(result, ruleName, {
      actual: pattern,
      possible: [_lodash["default"], _lodash2["default"]]
    });

    if (!validOptions) {
      return;
    }

    var regexpPattern = (0, _lodash2["default"])(pattern) ? new RegExp(pattern) : pattern;
    root.walkAtRules(function (decl) {
      if (decl.name !== "mixin") {
        return;
      } // Stripping the mixin of its arguments


      var mixinName = decl.params.replace(/(\s*?)\((?:\s|\S)*\)/g, "");

      if (regexpPattern.test(mixinName)) {
        return;
      }

      _stylelint.utils.report({
        message: messages.expected,
        node: decl,
        result: result,
        ruleName: ruleName
      });
    });
  };
}