import VariableDeclaration from './VariableDeclaration';
import Scope from '../scopes/Scope';
import ExecutionPathOptions from '../ExecutionPathOptions';
import { StatementBase, StatementNode } from './shared/Statement';
import { PatternNode } from './shared/Pattern';
import { NodeType } from './index';
import { ExpressionNode } from './shared/Node';
export default class ForInStatement extends StatementBase {
    type: NodeType.ForInStatement;
    left: VariableDeclaration | PatternNode;
    right: ExpressionNode;
    body: StatementNode;
    hasEffects(options: ExecutionPathOptions): boolean;
    initialiseChildren(): void;
    includeInBundle(): boolean;
    initialiseScope(parentScope: Scope): void;
}
