import Variable from './ast/variables/Variable';
import Graph from './Graph';
export default class ExternalModule {
    graph: Graph;
    declarations: {
        [name: string]: Variable;
    };
    exportsNames: boolean;
    exportsNamespace: boolean;
    id: string;
    isExternal: boolean;
    name: string;
    mostCommonSuggestion: number;
    nameSuggestions: {
        [name: string]: number;
    };
    reexported: boolean;
    used: boolean;
    constructor(graph: Graph, id: string);
    suggestName(name: string): void;
    warnUnusedImports(): void;
    traceExport(name: string): Variable;
}
