<?php

namespace FwAuthSystem\Role;

use controller\Categories;
use controller\Contractors;
use controller\Courses;
use controller\UserCourses;
use FwAuthSystem\Utils\AuthRole;

if (!class_exists('FwAuthSystem\Role\PersonnelRole')) {
    class PersonnelRole extends AuthRole
    {
        public static function accessList(): array
        {
            // list of available controllers for this role
            return [
                Categories::class,
                Courses::class,
                UserCourses::class,
            ];
        }

        public static function roleName(): string
        {
            // role main names
            return 'پرسنل سطح یک';
        }
    }
}