<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class ContactUs extends View
{

    public $SingularName = 'داده';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('عنوان'), HtmlTags::Th('توضیحات'), HtmlTags::Th('تصویر'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['contact_us_title', 'contact_us_description', 'contact_us_image'])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('contact_us_title') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('توضیحات') .
                                        $this->Html()->TextArea('contact_us_description') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('تصویر') .
                                        $this->Html()->ImageInput('contact_us_image') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('تصویر سوالات پرتکرار') .
                                        $this->Html()->ImageInput('contact_us_faq_image') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('شبکه های اجتماعی') .
                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('social_icon1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('social_title1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('social_name1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('social_link1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('social_icon2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('social_title2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('social_name2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('social_link2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('social_icon3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('social_title3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('social_name3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('social_link3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('social_icon4') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('عنوان') .
                                        $this->Html()->Input('social_title4') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('social_name4') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('social_link4') .
                                        $this->Html()->FormGroupEnd() .

                                        HtmlTags::Div('.alert.bg-dark.w-100')->Content('مجوز ها') .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('license_icon1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('license_name1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('license_link1') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('وضعیت') .
                                        $this->Html()->Select('license_status1','license_status1',HtmlTags::Option()->Value(1)->Content('فعال').HtmlTags::Option()->Value(0)->Content('غیر فعال')) .
                                        $this->Html()->FormGroupEnd() .



                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('license_icon2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('license_name2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('license_link2') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('وضعیت') .
                                        $this->Html()->Select('license_status2','license_status2',HtmlTags::Option()->Value(1)->Content('فعال').HtmlTags::Option()->Value(0)->Content('غیر فعال')) .
                                        $this->Html()->FormGroupEnd() .




                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('آیکون') .
                                        $this->Html()->ImageInput('license_icon3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('نام') .
                                        $this->Html()->Input('license_name3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('لینک') .
                                        $this->Html()->Url('license_link3') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(3) .
                                        $this->Html()->Label('وضعیت') .
                                        $this->Html()->Select('license_status3','license_status3',HtmlTags::Option()->Value(1)->Content('فعال').HtmlTags::Option()->Value(0)->Content('غیر فعال')) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        