$(function () {
    function generateRandomCode(length = 6) {
        const chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
        let result = '';
        for (let i = 0; i < length; i++) {
            result += chars.charAt(Math.floor(Math.random() * chars.length));
        }
        return result;
    }

    function getPlanDuration(planId) {
        const selectedOption = $('#global_plan_id').find('option:selected');
        return parseInt(selectedOption.attr('data-duration')) || 0;
    }

    function getTodayPlusDaysFormatted(days) {
        const today = new persianDate();
        const target = today.add('days', days);
        const g = target.toDate();
        const yyyy = g.getFullYear();
        const mm = String(g.getMonth() + 1).padStart(2, '0');
        const dd = String(g.getDate()).padStart(2, '0');
        return `${yyyy}-${mm}-${dd}`;
    }

    $('#global_plan_id').on('change', function () {
        const duration = getPlanDuration($(this).val());
        if (duration > 0) {
            let expire = getTodayPlusDaysFormatted(duration);
            let parent = $("#global_expire_date").parents('div.form-group');
            $("#global_expire_date").remove();
            $(parent).append(`<input type="text" value="${expire}" class="form-control" name="global_expire_date" id="global_expire_date" autocomplete="off" required="" readonly="readonly">`);
            $("#global_expire_date").persianDatepicker({initialValueType: 'gregorian'});
        }
    });

    $('#generate_codes').on('click', function () {
        const count = parseInt($('#code_count').val());
        if (!count || count <= 0) {
            Swal.fire('تعداد معتبر وارد کنید');
            return;
        }

        const planId = $('#global_plan_id').val();
        let expire = $('#global_expire_date').val();
        const referral = $('#global_referral_code').val();

        if (!expire || expire.trim() === '' || expire.includes('شنبه') || expire.includes('جمعه')) {
            const duration = getPlanDuration(planId);
            if (duration > 0) {
                expire = getTodayPlusDaysFormatted(duration);
                $('#global_expire_date').val(expire);
                $("#global_expire_date").persianDatepicker({initialValueType: 'gregorian'});
            }
        }

        let table = '<table class="table table-bordered mt-4">';
        table += '<thead><tr>';
        table += '<th>کد آنی کارت</th>';
        table += '<th>نوع اشتراک</th>';
        table += '<th>تاریخ انقضا</th>';
        table += '<th>کد معرف</th>';
        table += '</tr></thead><tbody>';

        for (let i = 0; i < count; i++) {
            const code = generateRandomCode();
            table += '<tr>';
            table += `<td><input type='text' name='codes[${i}][code]' class='form-control' value='${code}' ></td>`;
            table += `<td><select name='codes[${i}][plan_id]' class='form-control'>` +
                $('#global_plan_id option').map(function () {
                    const selected = $(this).val() == planId ? 'selected' : '';
                    return `<option value='${$(this).val()}' data-duration='${$(this).attr('data-duration')}' ${selected}>${$(this).text()}</option>`;
                }).get().join('') + '</select></td>';
            table += `<td><input type='text' name='codes[${i}][expire_date]' class='form-control persian-datepicker' value='${expire}'></td>`;
            table += `<td><input type='text' name='codes[${i}][referral_code]' class='form-control' value='${referral}'></td>`;
            table += '</tr>';
        }

        table += '</tbody></table>';
        $('#generated_codes_table').html(table);

        setTimeout(() => {
            $('.persian-datepicker').persianDatepicker({initialValueType: 'gregorian'});
        }, 0);
    });

    $.submit()
});
