<?php

namespace model;

use DATABASE\Model;
use fwJson\Json;
use PaymentInterface;

class  PaymentTable extends Model implements PaymentInterface {
    public static array $types = [
        'buyPlan' => 'خرید اشتراک',
    ];
    public $_table = 'PaymentTable';
    public $_key = 'payment_id';

    public static function toDataModel($item): array {
        $type = str($item->payment_type)->explode("_");
        return [
            'gate'        => $item->payment_gate,
            'date'        => jdate("Y/m/d", strtotime($item->payment_sdate)),
            'hour'        => jdate("H:i", strtotime($item->payment_sdate)),
            'isSucceeded' => $item->payment_status == 1,
            'amount'      => $item->payment_amount / 10,
            'code'        => $item->payment_resnum,
            'type'        => @self::$types[$item->payment_type] ?? $item->payment_type,
            'icon'        => __IMAGES__ . 'Payment/' . $type[0] . '.png',
        ];
    }

    public static function getType($payment_type) {
        return self::$types[$payment_type] ?? "Unknown";
    }

    public function save(int $customer_id, int $total_amount, string $resNum, Json $orderData, string $type) {
        if (
            $id = $this::add([
                                 'user_id'            => $customer_id,
                                 'payment_amount'     => $total_amount,
                                 $this->ResNumField() => $resNum,
                                 'payment_date'       => time(),
                                 'payment_type'       => $type,
                                 'payment_gate'       => 'زرین پال',
                                 'payment_data'       => $orderData->jsonSerialize(),
                                 'payment_from'       => $this->detectPaymentSource(),
                             ])) {
            return $id;
        }
        return false;
    }

    function detectPaymentSource(): string {
        $referer = $_SERVER['HTTP_REFERER'] ?? '';
        $userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';

        if (str($referer)->startsWith('http://') || str($referer)->startsWith('https://')) {
            return 'site';
        }
        return 'app';
    }

    public function ResNumField(): string {
        return 'payment_resnum';
    }

    public function RefNumField(): string {
        return 'payment_refnum';
    }

}
