<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AppVersionsMigration extends Migratable {
    const modelName = 'AppVersions';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('app_version_id');
			$blueprint->VarChar('platform')->Len(150);
			$blueprint->VarChar('version')->Len(150);
			$blueprint->VarChar('force_update')->Len(150);
			$blueprint->VarChar('download_url')->Len(150);
			$blueprint->VarChar('relaease_note')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
