<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class JobRequestsMigration extends Migratable {
    const modelName = 'JobRequests';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('job_request_id');
			$blueprint->VarChar('request_name')->Len(150);
			$blueprint->VarChar('request_mobile')->Len(150);
			$blueprint->VarChar('request_email')->Len(150);
			$blueprint->Text('request_description');
			$blueprint->VarChar('request_cv')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
