<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class JobsMigration extends Migratable {
    const modelName = 'Jobs';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('job_id');
			$blueprint->VarChar('job_title')->Len(150);
			$blueprint->VarChar('city_id')->Len(150);
			$blueprint->VarChar('job_type')->Len(150);
			$blueprint->Text('job_description');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
