<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class HomeSectionMigration extends Migratable {
    const modelName = 'HomeSection';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('home_sectio_id');
			$blueprint->VarChar('title')->Len(150);
			$blueprint->VarChar('image')->Len(150);
			$blueprint->VarChar('text')->Len(150);
			$blueprint->VarChar('button_text')->Len(150);
			$blueprint->VarChar('button_icon')->Len(150);
			$blueprint->VarChar('button_link')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
