<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ProvidersMigration extends Migratable {
    const modelName = 'Providers';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('provider_id');
			$blueprint->VarChar('provider_name')->Len(150);
			$blueprint->VarChar('provider_logo')->Len(150);
			$blueprint->Text('provider_description');
			$blueprint->VarChar('discount_percent')->Len(150);
			$blueprint->Int('guild_id')->Len(150);
			$blueprint->Int('state_id')->Len(150);
			$blueprint->Int('city_id')->Len(150);
			$blueprint->Int('region_id')->Len(150);
			$blueprint->Text('provider_address');
			$blueprint->VarChar('provider_longitude')->Len(150);
			$blueprint->VarChar('provider_latitude')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
