<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class UnitsMigration extends Migratable {
    const modelName = 'Units';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('unit_id');
			$blueprint->Int('floor_id')->Len(150);
			$blueprint->Int('guild_id')->Len(150);
			$blueprint->VarChar('unit_plate')->Len(150);
			$blueprint->VarChar('unit_name')->Len(150);
			$blueprint->VarChar('manager_name')->Len(150);
			$blueprint->VarChar('manager_mobile')->Len(150);
			$blueprint->VarChar('unit_tel')->Len(150);
			$blueprint->VarChar('unit_worktime')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
