<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CharityCategoriesMigration extends Migratable {
    const modelName = 'CharityCategories';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('charity_category_id');
			$blueprint->VarChar('charity_name')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
