<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class TransactionsMigration extends Migratable {
    const modelName = 'Transactions';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('transaction_id');
			$blueprint->Int('transaction_amount')->Len(150);
			$blueprint->Int('artist_id')->Len(150);
			$blueprint->VarChar('transaction_type')->Len(150);
			$blueprint->Int('wallet_pre_balance')->Len(150);
			$blueprint->Int('wallet_post_balance')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
