<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class AudioBooksMigration extends Migratable {
    const modelName = 'AudioBooks';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('audio_book_id');
			$blueprint->VarChar('audio_book_name')->Len(150);
			$blueprint->Int('artist_id')->Len(150);
			$blueprint->VarChar('audio_book_cover')->Len(150);
			$blueprint->Int('label_id')->Len(150);
			$blueprint->VarChar('is_ended')->Len(150);
			$blueprint->VarChar('is_daily')->Len(150);
			$blueprint->Int('membership_id')->Len(150);
			$blueprint->VarChar('audio_book_start_date')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
