<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ServiceAnswersMigration extends Migratable {
    const modelName = 'ServiceAnswers';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('service_answer_id');
			$blueprint->VarChar('service_aswer_title')->Len(150);
			$blueprint->Int('service_question_id')->Len(150);
			$blueprint->Int('service_answer_type')->Len(150);
			$blueprint->Int('service_answer_price')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
