<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class MenuItemsMigration extends Migratable {
    const modelName = 'MenuItems';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('menu_item_id');
			$blueprint->VarChar('menu_item_text')->Len(150);
			$blueprint->Int('file_id')->Len(150);
			$blueprint->Text('menu_item_link');
			$blueprint->Int('view_order')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
