<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class CoursesMigration extends Migratable {
    const modelName = 'Courses';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('course_id');
			$blueprint->VarChar('course_name')->Len(150);
			$blueprint->Text('course_details');
			$blueprint->VarChar('course_cover')->Len(150);
			$blueprint->VarChar('course_icon')->Len(150);
			$blueprint->Int('course_price')->Len(150);
			$blueprint->Int('course_pre_pay_percent')->Len(150);
			$blueprint->Int('course_max_pay_month')->Len(150);
			$blueprint->Int('file_id')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
