<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ClubSettingsMigration extends Migratable {
    const modelName = 'ClubSettings';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('club_setting_id');
			$blueprint->Int('complete_profile')->Len(150);
			$blueprint->Int('daily_exam_attendance')->Len(150);
			$blueprint->Int('invite_friends')->Len(150);
			$blueprint->Int('instagram')->Len(150);
			$blueprint->Int('buy_percent')->Len(150);
			$blueprint->Int('add_question')->Len(150);
			$blueprint->Int('add_text_content')->Len(150);
			$blueprint->Int('add_file_content')->Len(150);
			$blueprint->Int('add_video_content')->Len(150);
			$blueprint->Int('send_email_yes_no')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
