<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class UserRewardsEntity extends EntityScheme {
    public $user_reward_id;
    /**
     * نوع (امتیاز/اعتبار)
     **/
    public $reward_type;
    /**
     * مقدار دریافت (اعتبار به تومان وارد گردد)
     **/
    public $reward_amount;
    /**
     * علت
     **/
    public $reward_cause;

    public function model() {
        return new \model\UserRewards();
    }


    protected function dictionary(): array {
        return [
            'user_reward_id' => 'user_reward_id', 'reward_type' => 'user_reward_type', 'reward_amount' => 'user_reward_amount', 'reward_cause' => 'user_reward_cause',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'        => $this->user_reward_id,
            'type'      => $this->reward_type,
            'amount'    => $this->reward_amount,
            'cause'     => $this->reward_cause,
            'createdAt' => strtotime($this->created_at),
        ];
    }

}
