<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class NotificationsEntity extends EntityScheme {
	public $notification_id;
	/**
	 * تیتر
	 **/
	public $title;
	/**
	 * متن
	 **/
	public $text;
	public $url;

	public function model() {
		return new \model\Notifications();
	}

	public function apiFormat(?UsersEntity $user = null): array {
		$createdAt = strtotime($this->created_at);
		$lastSeen = time();
		if ($user instanceof UsersEntity) {
			$lastSeen = $user->last_notif_seen_date;
		}
		return [
			'id'    => $this->notification_id,
			'title' => $this->title,
			'text'  => $this->text,
			'url'   => $this->url,
			'date'  => jdate("Y/m/d", $createdAt),
			'time'  => jdate("H:i", $createdAt),
			'isRead' => $lastSeen > $createdAt,
		];
	}

	protected function dictionary(): array {
		return [
			'notification_id' => 'notification_id',
			'title'           => 'notification_title',
			'text'            => 'notification_text',
			'url'            => 'notification_url',
		];
	}
}
