<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Providers;
use model\Users;

class TransactionEntity extends EntityScheme {
    public $transaction_id;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * پذیرنده
     **/
    public $provider_id;
    /**
     * مبلغ
     **/
    public $price;

    public function model() {
        return new \model\Transaction();
    }


    protected function dictionary(): array {
        return [
            'transaction_id' => 'transaction_id',
            'user_id'        => 'user_id',
            'provider_id'    => 'provider_id',
            'price'          => 'transaction_price',
        ];
    }

    public function apiFormat(): array {
        /** @var UsersEntity $user */
        $user = Users::get($this->user_id);
        return [
            'id'              => $this->transaction_id,
            'user'            => $user instanceof UsersEntity ? $user->providerFormat() : [
                'id'           => 0,
                'image'        => __IMAGES__ . 'Users/placeholder.png',
                'name'         => "کاربر حذف شده",
                'mobile'       => "",
                'currentLimit' => 0,
            ],
            'price'           => $this->price,
            'discountPercent' => $this->discount_percent,
            'createdAt'       => strtotime($this->created_at),
        ];
    }

    public function userApiFormat(): array {
        /** @var ProvidersEntity $provider */
        $provider = Providers::get($this->provider_id);
        return [
            'id'              => $this->transaction_id,
            'provider'        => $provider->sliderFormat(),
            'price'           => $this->price,
            'discountPercent' => $this->discount_percent,
            'createdAt'       => strtotime($this->created_at),
        ];
    }

}
