<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\TicketCategories;
use model\Tickets;

class TicketsEntity extends EntityScheme {
    public $ticket_id;
    /**
     * نام
     **/
    public $name;
    /**
     * موبایل
     **/
    public $mobile;
    /**
     * ایمیل
     **/
    public $email;
    /**
     * موضوع
     **/
    public $category_id;
    /**
     * متن
     **/
    public $message;

    public function model() {
        return new \model\Tickets();
    }


    protected function dictionary(): array {
        return [
            'ticket_id'   => 'ticket_id',
            'name'        => 'name',
            'mobile'      => 'mobile',
            'email'       => 'email',
            'category_id' => 'ticket_category_id',
            'message'     => 'message',
        ];
    }

    public function apiFormat(): array {
        /** @var TicketCategoriesEntity $category */
        $category = TicketCategories::get($this->category_id);
        if ($category instanceof TicketCategoriesEntity){
            $category = $category->apiFormat();
        } else {
            $category = [
                'id'   => 0,
                'name' => "دسته بندی نشده"
            ];
        }
        $parent = \model\Tickets::Db()->where('parent_id',$this->ticket_id)->get()->first();
        if ($parent instanceof TicketsEntity){
            $answer = [
                'id' => $parent->ticket_id,
                'category' => $category,
                'message' => $parent->message,
                'createdAt' => strtotime($parent->created_at),
                'isSystem' => true,
            ];
        }else{
            $answer = [];
        }
        return [
          'ticket' => [
              'id' => $this->ticket_id,
              'category' => $category,
              'message' => $this->message,
              'hasResponse' => Tickets::Db()->where('parent_id', $this->ticket_id)->rowCount() > 0,
              'createdAt' => strtotime($this->created_at),
              'isSystem' => $this->user_id == 0,
          ],
          'answer' => $answer
        ];
//        return [
//            'id'          => $this->ticket_id,
//            'category'    => $category->apiFormat(),
//            'message'     => $this->message,
//            'hasResponse' => Tickets::Db()->where('parent_id', $this->ticket_id)->rowCount() > 0,
//            'createdAt'   => strtotime($this->created_at),
//            'isSystem'        => $this->user_id == 0,
//        ];

    }

}
