<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Attributes;
use model\Cities;
use model\Comments;
use model\Guilds;
use model\ProviderGalleries;
use model\Regions;
use model\States;

class ProvidersEntity extends EntityScheme {
    public $provider_id;
    /**
     * نام
     **/
    public $name;
    /**
     * موبایل
     **/
    public $mobile;
    /**
     * پسورد
     **/
    public $password;
    /**
     * لوگو
     **/
    public $logo;
    /**
     * توضیحات
     **/
    public $description;
    /**
     * درصد تخفیف
     **/
    public $discount_percent;
    /**
     * صنف
     **/
    public $guild_id;
    /**
     * استان
     **/
    public $state_id;
    /**
     * شهر
     **/
    public $city_id;
    /**
     * منطقه
     **/
    public $region_id;
    /**
     * آدرس
     **/
    public $address;
    /**
     * طول جغرافیایی
     **/
    public $longitude;
    /**
     * عرض جغرافیایی
     **/
    public $latitude;
    /**
     * @var void
     */
    public $limit;

    public function model() {
        return new \model\Providers();
    }


    protected function dictionary(): array {
        return [
            'provider_id'      => 'provider_id',
            'name'             => 'provider_name',
            'mobile'           => 'provider_mobile',
            'password'         => 'provider_password',
            'logo'             => 'provider_logo',
            'description'      => 'provider_description',
            'discount_percent' => 'discount_percent',
            'guild_id'         => 'guild_id',
            'state_id'         => 'state_id',
            'city_id'          => 'city_id',
            'region_id'        => 'region_id',
            'address'          => 'provider_address',
            'longitude'        => 'provider_longitude',
            'latitude'         => 'provider_latitude',
            'limit'            => 'provider_limit',
        ];
    }

    public function apiFormat(): array {
        $guild = Guilds::get($this->guild_id);
        $state = States::get($this->state_id);
        $city = Cities::get($this->city_id);
        $region = Regions::get($this->region_id);

        return [
            'id'              => $this->provider_id,
            'name'            => $this->name,
            'mobile'          => $this->mobile,
            'logo'            => __IMAGES__ . 'Providers/' . $this->logo,
            'description'     => $this->description,
            'discountPercent' => $this->discount_percent,
            'guild'           => $guild instanceof GuildsEntity ? $guild->apiFormat() : null,
            'state'           => $state instanceof StatesEntity ? $state->apiFormat() : null,
            'city'            => $city instanceof CitiesEntity ? $city->apiFormat() : null,
            'region'          => $region instanceof RegionsEntity ? $region->apiFormat() : null,
            'address'         => $this->address,
            'longitude'       => $this->longitude,
            'latitude'        => $this->latitude,
            'saleLimit'       => $this->limit,
            'createdAt'       => jdate("Y/m/d", strtotime($this->created_at)),
        ];
    }

    public function sliderFormat(): array {

        /** @var CitiesEntity $city */
        $city = Cities::get($this->city_id);
        /** @var RegionsEntity $region */
        $region = Regions::get($this->region_id);
        $guild = Guilds::get($this->guild_id);

        $rate = Comments::Db()->where('provider_id', $this->provider_id)->where('status', 1)->get();
        $rates = [];
        foreach ($rate as $item) {
            $rates[] = $item->rate;
        }


        return [
            'id'       => $this->provider_id,
            'name'     => $this->name,
            'discount' => $this->discount_percent,
            'rate'     => (count($rates) > 0 ? round(array_sum($rates) / count($rates),1) : 0).'',
            'guild'    => $guild instanceof GuildsEntity ? $guild->apiFormat() : null,
            'location' => $city->name . ' ' . $region->name,
            'image'    => __IMAGES__ . 'Providers/' . $this->logo,
        ];
    }

    public function singleApiFormat(): array {
        $guild = Guilds::get($this->guild_id);
        $state = States::get($this->state_id);
        $city = Cities::get($this->city_id);
        $region = Regions::get($this->region_id);
        $galleries = ProviderGalleries::Db()->where('provider_id', $this->provider_id)->get()->filter(function (ProviderGalleriesEntity $galleriesEntity) {
            return is_file(__SOURCE__ . 'images/ProviderGalleries/' . $galleriesEntity->image);
        })->map(function (ProviderGalleriesEntity $galleriesEntity) {
            return __IMAGES__ . 'ProviderGalleries/' . $galleriesEntity->image;
        });
        $comments = Comments::Db()->where('provider_id', $this->provider_id)->where('status', 1)->get()->map(function (CommentsEntity $commentsEntity) {
            return $commentsEntity->apiFormat();
        });
        $attributes = Attributes::Db()->whereIn('attribute_id', json_decode($this->attribute_ids, true) ?? [])->get()->map(function (AttributesEntity $attributesEntity) {
            return $attributesEntity->apiFormat();
        });
        $rate = Comments::Db()->where('provider_id', $this->provider_id)->where('status', 1)->get();
        $rates = [];
        foreach ($rate as $item) {
            $rates[] = $item->rate;
        }


        return [
            'id'              => $this->provider_id,
            'name'            => $this->name,
            'mobile'          => $this->mobile,
            'logo'            => __IMAGES__ . 'Providers/' . $this->logo,
            'rate'     => (count($rates) > 0 ? round(array_sum($rates) / count($rates),1) : 0).'',
            'rating'     => (count($rates) > 0 ? round(array_sum($rates) / count($rates),1) : 0).'',
            'description'     => $this->description,
            'discountPercent' => $this->discount_percent,
            'guild'           => $guild instanceof GuildsEntity ? $guild->apiFormat() : null,
            'state'           => $state instanceof StatesEntity ? $state->apiFormat() : null,
            'city'            => $city instanceof CitiesEntity ? $city->apiFormat() : null,
            'region'          => $region instanceof RegionsEntity ? $region->apiFormat() : null,
            'address'         => $this->address,
            'longitude'       => $this->longitude,
            'latitude'        => $this->latitude,
            'saleLimit'       => $this->limit,
            'createdAt'       => jdate("Y/m/d", strtotime($this->created_at)),
            'galleries'       => $galleries,
            'comments'        => $comments,
            'workHours'       => json_decode($this->provider_work_hours) ?? [],
            'attributes'      => $attributes,
        ];
    }


}
