<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class AttributesEntity extends EntityScheme {
    public $attribute_id;
    /**
     * عنوان
     **/
    public $name;
    /**
     * توضیح
     **/
    public $value;
    /**
     * پذیرنده ها
     **/
    public $provider_ids;

    public function model() {
        return new \model\Attributes();
    }


    protected function dictionary(): array {
        return [
            'attribute_id' => 'attribute_id', 'name' => 'attribute_name', 'value' => 'attribute_value', 'provider_ids' => 'provider_ids',
        ];
    }

    public function apiFormat(): array {
        return [
            'id'    => $this->attribute_id,
            'name'  => $this->name,
            'value' => $this->value,
        ];
    }

}
