<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class PlanPageEntity extends EntityScheme
{
    public $plan_page_id;
    /**
     * عنوان
     **/
    public $title;
    /**
     * توضیحات
     **/
    public $description;
    /**
     * عنوان پاپ آپ
     **/
    public $popup_title;
    /**
     * توضیحات پاپ آپ
     **/
    public $popup_description;

    public function model()
    {
        return new \model\PlanPage();
    }

    public function apiFormat()
    {
        $plans = \model\Plans::Db()->where('status',1)->get()->map(function (PlansEntity $plan) {
            return $plan->buyPlanPageApiFormat();
        });
        return [
            'title' => $this->title,
            'description' => $this->description,
            'plans' => $plans,
            'popupTitle' => $this->popup_title,
            'popupDescription' => $this->popup_description
        ];
    }


    protected function dictionary(): array
    {
        return [
            'plan_page_id' => 'plan_page_id', 'title' => 'title', 'description' => 'description', 'popup_title' => 'popup_title', 'popup_description' => 'popup_description',
        ];
    }
}
