<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Scores;

class PointsEntity extends EntityScheme {
    public $point_id;
    /**
     * موقعیت
     **/
    public $cause;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * امتیاز
     **/
    public $score;
    public $type;

    public function model() {
        return new \model\Points();
    }

    public function apiFormat(): array {
        $score = $this->score_id > 0 ? @Scores::get($this->score_id)->apiFormat() : null;
        return [
            'id'        => $this->point_id,
            'cause'     => $this->cause,
            'score'     => $this->score,
            'mission'   => $score,
            'createdAt' => strtotime($this->created_at),
        ];
    }

    protected function dictionary(): array {
        return [
            'point_id' => 'point_id',
            'cause'    => 'point_cause',
            'user_id'  => 'user_id',
            'score'    => 'point_score',
            'type'    => 'point_type',
        ];
    }
}
