<?php

class SmsIR_UltraFastSend {

	public function __construct($APIKey, $SecretKey, $APIURL) {
		$this->APIKey = $APIKey;
		$this->SecretKey = $SecretKey;
		$this->APIURL = $APIURL;
	}

	public function ultraFastSend($data) {
		$token = $this->_getToken($this->APIKey, $this->SecretKey);
		if ($token != false) {
			$postData = $data;

			$url = $this->APIURL . $this->getAPIUltraFastSendUrl();
			$UltraFastSend = $this->_execute($postData, $url, $token);
			$object = json_decode($UltraFastSend);

			$result = false;
			
			if (is_object($object)) {
				$result = $object->Message;
			} else {
				$result = false;
			}
		} else {
			$result = false;
		}
		return $result;
	}

	private function _getToken() {
		$postData = array(
			'UserApiKey' => $this->APIKey,
			'SecretKey'  => $this->SecretKey,
			'System'     => 'php_rest_v_2_0'
		);
		$postString = json_encode($postData);

		$ch = curl_init($this->APIURL . $this->getApiTokenUrl());
		curl_setopt(
			$ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json'
			)
		);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

		$result = curl_exec($ch);
		curl_close($ch);

		$response = json_decode($result);

		$resp = false;
		$IsSuccessful = '';
		$TokenKey = '';
		if (is_object($response)) {
			$IsSuccessful = $response->IsSuccessful;
			if ($IsSuccessful == true) {
				$TokenKey = $response->TokenKey;
				$resp = $TokenKey;
			} else {
				$resp = false;
			}
		}
		return $resp;
	}

	protected function getApiTokenUrl() {
		return "api/Token";
	}

	protected function getAPIUltraFastSendUrl() {
		return "api/UltraFastSend";
	}

	private function _execute($postData, $url, $token) {
		$postString = json_encode($postData);
		$ch = curl_init($url);
		curl_setopt(
			$ch, CURLOPT_HTTPHEADER, array(
				'Content-Type: application/json',
				'x-sms-ir-secure-token: ' . $token
			)
		);
		curl_setopt($ch, CURLOPT_HEADER, false);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $postString);

		$result = curl_exec($ch);
		curl_close($ch);

		return $result;
	}
}



?>
