class ReportsClass {
    constructor() {
        this.setControllerType('getReport');
        this.setFiltersFieldName('filters');
    }

    setUrl(url) {
        this.url = url;
    }

    setControllerType(controller_type) {
        this.controller_type = controller_type;
    }

    setFiltersFieldName(filter_field_name) {
        this.filter_field_name = filter_field_name;
    }

    submit() {
        let object = {};
        $("[name^=fw_report_]").each(function () {
            if (this.tagName.toString() === 'SELECT') {
                if ($(this).find('option:selected').length > 0) {
                    object[this.name.toString().replace('fw_report_', '')] = $(this).find('option:selected').val();


                }
            } else {
                if (this.value != '') {
                    switch ($(this).attr('type')) {
                        case "radio":
                        case "checkbox":
                            if ($(this).is(':checked')) {
                                object[this.name.toString().replace('fw_report_', '')] = $(this).val();
                            }
                            break;
                        default:
                            object[this.name.toString().replace('fw_report_', '')] = $(this).val();
                            break;
                    }
                }
            }
        })
        let data = {
            controller_type: this.controller_type,
        };
        data[this.filter_field_name] = object;
        $.ajax({
            url: this.url,
            data: data,
            type: 'post',
            success: res => {

                $("#submit_btn").find('i').attr('class', 'fa fa-edit m-2');
                $("#submit_btn").find('span').text('ویرایش');
                try {
                    let json = JSON.parse(res);
                    if (json.status == true) {
                        $("#res").html(json.html)
                        $.table();

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'خطایی رخ داد!',
                            text: 'در بارگزاری اطلاعات خطایی رخ داد',
                            showConfirmButton: false,
                            showCloseButton: true
                        })
                    }
                } catch (e) {
                    Swal.fire({
                        icon: 'error',
                        title: 'خطایی رخ داد!',
                        text: 'در بارگزاری اطلاعات خطایی رخ داد (خطای واکشی)',
                        showConfirmButton: false,
                        showCloseButton: true
                    })
                }
            }
        });
    }

    init() {
        let instance = this;
        $("[id$=date_from]").on('focus', function () {
            $(this).persianDatepicker({
                onSelect: date => {
                    instance.start_date = date;
                }
            })
        });
        $("[id^=simple_date_fw_report_]").each(function () {
            $(this).persianDatepicker()
        });
        $("[id$=date_to]").on('focus', function () {

            if (instance.start_date && !$(this).val()) {
                $(this).persianDatepicker({
                    minDate: new Date(instance.start_date)
                })
            } else if (!instance.isSet) {
                $(this).persianDatepicker()
            }
            instance.isSet = true;

        });
        $("[id*=date]").attr('readonly', true);
        $('#submit_btn').on('click', function (e) {

            // alert('hoi')
            let element = $("#formDiv");
            if ($(element).is(":visible")) {
                $("#submit_btn").find('i').attr('class', 'fa fa-spin fa-spinner m-2');
                $("#submit_btn").find('span').text('درحال پردازش');
                Reports.submit();
                $(element).slideUp();
            } else {
                $("#submit_btn").find('i').attr('class', 'fa fa-download m-2');
                $("#submit_btn").find('span').text('دریافت گزارش');
                $(element).slideDown();
                $("#res").empty();
            }
        });
        $("#percent").checkNumber({
            maxNum: '2'
        });
        $(".btn-danger[type=reset]").on('click', function () {
            setTimeout(() => {
                $("select").each(function () {
                    if ($(this).data('select2')) {
                        $(this).select2('destroy');
                        $(this).select2();
                    }
                })
            }, 1);
        });
    }

}

const Reports = new ReportsClass();

