<?php

namespace controller;

use ControllerScheme;
use model\Entity\ProvidersEntity;
use model\Entity\UsersEntity;

class Notifications extends ControllerScheme {
	const name = 'نوتیفیکیشن';

	protected function add(?bool $csrf = true) {
		$userIds = $this->requestArray('user_id')?:[];
		$providerIds = $this->requestArray('provider_id')?:[];
		$title = $this->requestArray('notification_title');
		$text = $this->requestArray('notification_text');
		$tokens = [];
		if (in_array('all', $userIds)) {
			$users = \model\Users::getAll();
			$tokens = \model\Users::Db()->where('firebase_token', 'is not', null)->get()->map(function (UsersEntity $devicesEntity) {
				return $devicesEntity->firebase_token;
			})->values()->all();
		} else {
			$users = \model\Users::Db()->whereIn('user_id', (array)$userIds)->get();
		}
		foreach ($users as $user) {

			if ($user instanceof UsersEntity && strlen($user->firebase_token . '') > 1) {
				$tokens[] = $user->firebase_token;
			}
		}
		$tokens = array_unique($tokens);
		foreach ($tokens as $token) {
			echo sendPushNotification($token, $title, null, $text) . '<br>';
		}

        $providerTokens = [];
        if (in_array('all', $providerIds)) {
            $providers = \model\Providers::getAll();
            $providerTokens = \model\Providers::Db()->where('firebase_token', 'is not', null)->get()->map(function (ProvidersEntity $devicesEntity) {
                return $devicesEntity->firebase_token;
            })->values()->all();
        } else {
            $providers = \model\Providers::Db()->whereIn('provider_id', (array)$providerIds)->get();
        }
        foreach ($providers as $provider) {

            if ($provider instanceof ProvidersEntity && strlen($provider->firebase_token . '') > 1) {
                $providerTokens[] = $provider->firebase_token;
            }
        }
        $providerTokens = array_unique($providerTokens);
        foreach ($providerTokens as $providerToken) {
            echo sendPushNotification($providerToken, $title, null, $text) . '<br>';
        }

		return parent::add($csrf); // TODO: Change the autogenerated stub
	}

    public function main() {
        return parent::addIndex(); // TODO: Change the autogenerated stub

    }
}