<?php
namespace controller;
use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Cities extends ControllerScheme {
    const name = 'شهر';

    public function getCities()
    {
        $state = $this->requestArray()['id'];
        $cities = \model\Cities::getAllFiltered('state_id',$state);
        $output =[HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
        foreach ($cities as $city){
            $output[]=HtmlTags::Option()->Value($city->city_id)->Content($city->city_name);
        }
        return implode('.',$output);

    }
    
}