<?php

namespace routes\v1;

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwHtml\Elements\Tags\P;
use fwJson\Json;
use FwRoutingSystem\Router;
use model\AppAboutUs;
use model\AppVersions;
use model\BlogCategories;
use model\Blogs;
use model\Cities;
use model\Codes;
use model\Companies;
use model\Entity\AppAboutUsEntity;
use model\Entity\BlogCategoriesEntity;
use model\Entity\BlogsEntity;
use model\Entity\CitiesEntity;
use model\Entity\CodesEntity;
use model\Entity\CompaniesEntity;
use model\Entity\GuildsEntity;
use model\Entity\JobsEntity;
use model\Entity\MiddleBannersEntity;
use model\Entity\NotificationsEntity;
use model\Entity\PlanPageEntity;
use model\Entity\PlansEntity;
use model\Entity\ProvidersEntity;
use model\Entity\RulesEntity;
use model\Entity\SecondaryTopBannersEntity;
use model\Entity\SettingsEntity;
use model\Entity\SlidersEntity;
use model\Entity\StatesEntity;
use model\Entity\TopBannersEntity;
use model\Entity\UserRewardsEntity;
use model\Entity\UsersEntity;
use model\Entity\UserTempEntity;
use model\Entity\WelcomePageEntity;
use model\Entity\WithdrawRequestsEntity;
use model\Guilds;
use model\HomeSection;
use model\Jobs;
use model\MiddleBanners;
use model\Notifications;
use model\Plans;
use model\Points;
use model\Providers;
use model\Rules;
use model\Scores;
use model\SecondaryTopBanners;
use model\Settings;
use model\Sliders;
use model\States;
use model\TopBanners;
use model\UserRewards;
use model\Users;
use model\UserTemp;
use model\PaymentTable;
use model\WithdrawRequests;
use site\helpers\ZarinPalPayment;
use version\ApiVersions;

class MainRoute extends \Api\BaseRouter {
    public string $version = ApiVersions::one;
    public $groupPath = 'main';

    public function routes(Router $router) {
        $router->any('/update', function () {
            $platform = @$this->getParam('platform');
            $currentVersion = @$this->getParam('version');

            if (!$platform || !$currentVersion) {
                return response([
                                    'message' => 'Platform and version are required'
                                ], 400);
            }

            $latest = AppVersions::Db()->orderBy('created_at', true)->get()
                                 ->first();

            if (!$latest) {
                return response([
                                    'message' => 'No version info found',
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        'is_update_available' => false,
                                ], 200);
            }

            if (version_compare($currentVersion, @$latest->version, '<')) {
                return response([
                                    'is_update_available' => true,
                                    'is_force_update'     => (bool)$latest->force_update,
                                    'latest_version'      => $latest->version,
                                    'download_url'        => $latest->download_url,
                                    'release_notes'       => $latest->release_note,
                                ], 200);
            } else {
                return response([
                                    'is_update_available' => false,
                                ], 200);
            }
        });

        $router->get('/welcome-page', function () {
            $data = \model\WelcomePage::get(1);
            /** @var WelcomePageEntity $data */
            return response([
                                $data->apiFormat(),
                            ]);
        });
        $router->get('/buy-plan-page', function () {
            $data = \model\PlanPage::get(1);
            /** @var PlanPageEntity $data */
            return response([
                                $data->apiFormat(),
                            ]);
        });
        $router->post('/deposit', $this->middleware($router), function () {
            $amount = $this->getParam('amount');
            $user = Users::findToken(get_header('auth'));

            $payment = new ZarinPalPayment();
            $payment->initPayment(new PaymentTable());
            $payment->UserModel(new Users(), $user);
            $payment->_amount = $amount * 10;
            $payment->Type('deposit');
            $payment->OrderData(Json::encode([
                'amount' => $amount,
                'userId' => $user->id,
                'before' => $user->user_credit,
                                             ]));
            $result = $payment->goToPayment();
            if (filter_var($result, FILTER_VALIDATE_URL)) {
                return response(['pay' => $result]);
            } else {
                return response(['message' => $result], 400);
            }
        });

        $router->get('/index', function () {
            $banners = [
                ...TopBanners::Db()->get()->map(function (TopBannersEntity $banner) {
                    return $banner->apiFormat();
                })->all(), ...SecondaryTopBanners::Db()->get()->map(function (SecondaryTopBannersEntity $banner) {
                    return $banner->apiFormat();
                })->all(), ...MiddleBanners::Db()->get()->map(function (MiddleBannersEntity $banner) {
                    return $banner->apiFormat();
                })->all()
            ];
            $categories = Guilds::Db()->get()->map(function (GuildsEntity $guild) {
                return $guild->apiFormat();
            });
            $sliders = Sliders::Db()->get()->map(function (SlidersEntity $slider) {
                return $slider->apiFormat();
            });
            $partners = Companies::Db()->get()->map(function (CompaniesEntity $company) {
                return $company->apiFormat();
            });
            $data = HomeSection::get(1)->apiFormat();

            $footer = \model\Settings::get(1);
            /** @var SettingsEntity $footer */


            return response([
                                'banners'    => $banners,
                                'categories' => $categories,
                                'sliders'    => $sliders,
                                'partners'   => $partners,
                                'data'       => $data,
                                'footer'     => $footer->footerApiFormat()
                            ]);
        });

        $router->any('/notifications', $this->middleware($router), function () {
            $provider = Providers::findToken(get_header('auth'));
            $notifications = Notifications::Db()->get()->map(function (NotificationsEntity $notification) {
                return $notification->apiFormat();
            })->values();
            return response($notifications, 201);
        });

        $router->get('/categories', function () {
            $categories = Guilds::Db()->get()->map(function (GuildsEntity $guild) {
                return $guild->apiFormat();
            });
            return response($categories, 201);
        });

        $router->post('/providers', function () {
            $category = $this->getParam('category', false);
            $query = $this->getParam('query', false);
            $city = $this->getParam('city', false);
            $sort = $this->getParam('sort', false);


            $providers = Providers::Db();
            if ($category > 0) {
                $providers = $providers->where('guild_id', $category);
            }
            if (strlen($query) > 0) {
                $providers = $providers->where('provider_name', "like", "%$query%");
            }
            if ($city > 0) {
                $providers = $providers->where('city_id', $city);
            }
            if ($sort) {
                switch ($sort) {
                    case "جدیدترین":
                        $providers = $providers->orderBy('provider_id', true);
                        break;
                    case "بیشترین تخفیف":
                        $providers = $providers->orderBy('discount_percent', true);
                        break;
                    case "بیشترین امتیاز":
                        $providers = $providers->orderBy('provider_mobile', true);
                        break;
                    case "پربازدیدترین":
                        $providers = $providers->orderBy('provider_name', false);
                        break;
                    default:
                        $providers = $providers->orderBy('provider_id', false);
                        break;

                }
            }
            $providers = $providers->get()->map(function (ProvidersEntity $provider) {
                return $provider->sliderFormat();
            });
            return response($providers, 201);
        });
        $router->get('/provider/:id', function ($id) {
            $provider = Providers::get($id);
            if ($provider instanceof ProvidersEntity) {
                $similar = Providers::Db()->where('provider_id', "!=", $provider->provider_id)->where('guild_id', $provider->guild_id)->where('city_id', $provider->city_id)->get()->map(function (ProvidersEntity $provider) {
                    return $provider->sliderFormat();
                });
                return response([
                                    'provider' => $provider->singleApiFormat(),
                                    'similar'  => $similar,
                                ], 201);
            } else {
                return response(['message' => 'پذیرنده یافت نشد'], 404);
            }
        });

        $router->get('/blog-categories', function () {
            $categories = BlogCategories::Db()->get()->map(function (BlogCategoriesEntity $category) {
                return $category->apiFormat();
            });
            return response($categories, 201);
        });

        $router->post('/blogs', function () {
            $category = $this->getParam('category', false);
            $query = $this->getParam('query', false);
            $sort = $this->getParam('sort', false);


            $blogs = Blogs::Db();
            if ($category > 0) {
                $blogs = $blogs->where('category_id', $category);
            }
            if (strlen($query) > 0) {
                $blogs = $blogs->where('blog_title', "like", "%$query%");
            }
            $blogs = $blogs->get()->map(function (BlogsEntity $blog) {
                return $blog->apiFormat();
            });
            return response($blogs);
        });
        $router->get('/blog/:id', function ($id) {
            $blog = Blogs::get($id);
            if ($blog instanceof BlogsEntity) {
                $similar = Blogs::Db()->where('blog_id', "!=", $blog->blog_id)->where('category_id', $blog->category_id)->get()->map(function (BlogsEntity $blog) {
                    return $blog->apiFormat();
                });
                \model\Blogs::edit($id, [
                    'views_count' => $blog->views_count + 1
                ]);
                $blog = Blogs::get($id);
                $user = Users::findToken(get_header('auth'));
                if ($user instanceof UsersEntity) {
                    Points::award($user, Scores::getBy(9), 'مشاهده پست ' . $blog->blog_title);
                }
                return response([
                                    'blog' => $blog->singleApiFormat(),
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        'similar' => $similar,

                                ], 201);
            } else {
                return response(['message' => 'مقاله یافت نشد'], 404);
            }
        });


        $router->group('/job', function (Router $router) {
            $router->get('/jobs', function () {
                $jobs = Jobs::Db()->get()->map(function (JobsEntity $job) {
                    return $job->apiFormat();
                });
                return response($jobs);
            });
            $router->get('/job/:id', function ($id) {
                /** @var JobsEntity $job */
                $job = Jobs::get($id);
                return response([
                                    $job->singleApiFormat(),
                                ]);

            });
            $router->post('/request', function () {
                $jobId = $this->getParam('jobId');
                $name = $this->getParam('name');
                $mobile = $this->getParam('mobile');
                $email = $this->getParam('email', false) ?: "";
                $description = $this->getParam('description');
                $cv = $_FILES['cv'];
                $job = \model\Jobs::get($jobId);
                if ($job instanceof JobsEntity) {
                    $extension = pathinfo($cv['name'], PATHINFO_EXTENSION);
                    $newFileName = 'request_cv' . time() . '.' . $extension;
                    $destinationPath = __SOURCE__ . "images/JobRequests/" . $newFileName;
                    if (move_uploaded_file($cv['tmp_name'], $destinationPath)) {
                        if (
                            \model\JobRequests::add([
                                                        'job_id'              => $jobId,
                                                        'request_name'        => $name,
                                                        'request_mobile'      => $mobile,
                                                        'request_email'       => $email,
                                                        'request_description' => $description,
                                                        'request_cv'          => $newFileName
                                                    ])
                        ) {
                            return response(['message' => "درخواست شما با موفقیت ثبت شد"]);
                        } else {
                            return response(['message' => "خطایی در ثبت درخواست رخ داد"], 400);
                        }
                    } else {
                        return response(['message' => "خطایی در بارگذاری رزومه رخ داد"], 400);
                    }
                } else {
                    return response(['message' => "شغل یافت نشد"], 404);
                }


            });
        });

        $router->post('/submit-comment', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $provider_id = $this->getParam('provider');
            $anonymous = $this->getParam('anonymous');
            $rate = $this->getParam('rate', false);
            $comment = $this->getParam('comment');


            $allowedComments = \model\Transaction::Db()->where('user_id', $user->user_id)->where('provider_id', $provider_id)->rowCount() + 1;
            $comments = \model\Comments::Db()->where('user_id', $user->user_id)->where('provider_id', $provider_id)->rowCount();
            if ($comments >= $allowedComments) {
                return response(['message' => 'برای ثبت نظر باید از این فروشگاه خرید جدیدی انجام دهید'], 403);
            }

            $badWords = \model\BadWords::Db()->get()->all();
            $badWordsArray = array_map(function ($bw) {
                return mb_strtolower(trim($bw->bad_word_value));
            }, $badWords);
            $commentLower = mb_strtolower($comment);
            foreach ($badWordsArray as $badWord) {
                if (mb_strpos($commentLower, $badWord) !== false) {
                    return response(['message' => 'کامنت شامل کلمات ممنوعه است'], 403);
                }
            }

            if (
                \model\Comments::add([
                                         'user_id'     => $user->user_id,
                                         'provider_id' => $provider_id,
                                         'comment'     => $comment,
                                         'anonymous'   => $anonymous,
                                         'rate'        => $rate,
                                         'status'      => 1
                                     ])) {
                Points::award($user, Scores::getBy(8), "ثبت نظر برای پذیرنده");
                return response([
                                    'message' => 'کامنت ثبت شد!'
                                ]);
            } else {
                return response(['message' => "خطایی در ثبت کامنت رخ داد"], 400);
            }


        });
        $router->post('/submit-blog-comment', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $blog_id = $this->getParam('blog');
            $comment = $this->getParam('comment');


            $badWords = \model\BadWords::Db()->get()->all();
            $badWordsArray = array_map(function ($bw) {
                return mb_strtolower(trim($bw->bad_word_value));
            }, $badWords);
            $commentLower = mb_strtolower($comment);
            foreach ($badWordsArray as $badWord) {
                if (mb_strpos($commentLower, $badWord) !== false) {
                    return response(['message' => 'کامنت شامل کلمات ممنوعه است'], 403);
                }
            }

            if (
                \model\BlogComments::add([
                                             'user_id'         => $user->user_id,
                                             'blog_id'         => $blog_id,
                                             'comment_content' => $comment,
                                         ])) {
                Points::award($user, Scores::getBy(2), 'ثبت نظر وبلاگ');
                return response([
                                    'message' => 'کامنت ثبت شد!'
                                ]);
            } else {
                return response(['message' => "خطایی در ثبت کامنت رخ داد"], 400);
            }


        });

        $router->get('/wallet', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $rewards = UserRewards::Db()->where('user_id', $user->user_id)->get()->map(function (UserRewardsEntity $userRewards) {
                return $userRewards->apiFormat();
            });
            $withdraws = WithdrawRequests::Db()->where('user_id', $user->user_id)->orderBy('created_at',true)->get()->map(function (WithdrawRequestsEntity $withdraws) {
                return $withdraws->apiFormat();
            });
            return response([
                                'transactions' => $rewards,
                                'withdraws'    => $withdraws,
                            ]);
        });
        $router->get('/states', function () {
            return response(States::Db()->get()->map(function (StatesEntity $states) {
                return $states->apiFormat();
            }));
        });
        $router->get('/cities/:id', function ($id) {
            return response(Cities::Db()->where('state_id', $id)->get()->map(function (CitiesEntity $city) {
                return $city->apiFormat();
            }));
        });


        $router->get('/footer', function () {
            $footer = \model\Settings::get(1);
            /** @var SettingsEntity $footer */
            return response([
                                'data' => $footer->footerApiFormat()
                            ]);
        });


        $router->post('/withdraw-request', $this->middleware($router), function () {
            $user = Users::findToken(get_header('auth'));
            $price = $this->getParam('price');
            $sheba = $this->getParam('sheba', false) ?? null;
            $minimum = \model\Settings::get(1)->minimum_withdraw;
            if ($price < $minimum) {
                return response([
                                    'message' => 'حداقل مبلغ برداشت ' . price_format($minimum) . " است."
                                ], 403);
            }

            if (!$user instanceof UsersEntity) {
                return response(['message' => 'کاربر یافت نشد'], 404);
            }
            if ($user->user_credit < $price) {
                return response(['message' => 'مبلغ وارد شده از اعتبار کیف پول شما بیشتر است'], 403);
            }
            if (!$sheba) {
                if (!$user->user_sheba) {
                    return response(['message' => 'لطفا ابتدا شماره شبای خود را در بخش تکمیل پروفایل وارد کنید'], 403);
                }
            }
            \model\Users::edit($user->user_id, [
                'user_credit' => $user->user_credit - $price,
            ]);
            if (
                \model\WithdrawRequests::add([
                                                 'user_id'        => $user->user_id,
                                                 'request_amount' => $price,
                                                 'request_sheba'  => $sheba ?? $user->user_sheba,
                                             ])) {
                return response(['message' => 'درخواست شما ثبت شده و مبلغ درخواستی تا 72 ساعت آینده به حسابتان واریز خواهد شد']);
            } else {
                return response(['message' => 'خطا در ثبت اطلاعات'], 400);

            }


        });
        $router->post('/submit-email', function () {
            $email = $this->getParam('email');
            if (
                \model\Emails::add([
                                       'email' => $email
                                   ])) {
                return response(['message' => 'ایمیل شما در خبرنامه آنیکارت ثبت شد'], 201);
            } else {
                return response(['message' => 'خطا در ثبت اطلاعات'], 400);
            }
        });


    }

    public function requiredHeaders(): array {
        return $this->auth();
    }


}
