<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;

use helpers\DayHelper;
use model\Entity\AttributesEntity;
use View;

class Providers extends View
{


    public $SingularName = 'پذیرنده';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                            HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                                ->Content(
                                                    HtmlTags::Table('.table.table-bordered.table-striped')
                                                        ->Content(
                                                            HtmlTags::Thead('.table-dark')
                                                                ->Content(
                                                                    HtmlTags::Tr()->Content(
                                                                        HtmlTags::Th('ردیف')->Width('50'),
                                                                        HtmlTags::Th('نام'),
                                                                        HtmlTags::Th('درصد تخفیف'),
                                                                        HtmlTags::Th('صنف'),
                                                                        HtmlTags::Th('آدرس')->Width("500"),
                                                                        HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                    )
                                                                ),
                                                            HtmlTags::Tbody()
                                                                ->Content(
                                                                    $this->show([

                                                                        function ($item) {
                                                                            return $item->provider_name . ' (' . $item->provider_mobile . ")";
                                                                        },
                                                                        'discount_percent' => function ($item) {
                                                                            return $item . ' %';
                                                                        },
                                                                        'guild_id' => function ($id) {

                                                                            return \model\Guilds::get($id)->name;
                                                                        },
                                                                        function ($row) {
                                                                            $state = "استان " . \model\States::get($row->state_id)->name;
                                                                            $city = "شهر " . \model\Cities::get($row->city_id)->name;
                                                                            $region = "منطقه " . \model\Regions::get($row->region_id)->name;
                                                                            $address = $row->provider_address;
                                                                            return $state . ' ، ' . $city . ' ، ' . $region . ' ، ' . $address;
                                                                        }
                                                                    ])
                                                                )
                                                        )
                                                )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نام ') .
                                        $this->Html()->Input('provider_name') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('تصویر اصلی') .
                                        $this->Html()->ImageInput('provider_logo', 'image/*', 150, 150) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('موبایل ') .
                                        $this->Html()->Mobile('provider_mobile') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('پسورد (رمزنگاری شده) ') .
                                        $this->Html()->Password('provider_password') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('درباره فروشگاه') .
                                        $this->Html()->TextArea('provider_description') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('درصد تخفیف') .
                                        $this->Html()->Price('discount_percent', 'discount_percent', '%') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('صنف') .
                                        $this->Html()->Select('guild_id', 'guild_id', \model\Guilds::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('محدودیت پذیرنده (ماهانه)') .
                                        $this->Html()->Price('provider_limit', 'provider_limit', 'خرید', '', false) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('استان') .
                                        $this->Html()->Select('state_id', 'state_id', \model\States::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('شهر') .
                                        $this->Html()->Select('city_id', 'city_id', \model\Cities::toOption(), false, true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('منطقه') .
                                        $this->Html()->Select('region_id', 'region_id', \model\Regions::toOption(), false, true, true) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('آدرس') .
                                        $this->Html()->Input('provider_address') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('لوکیشن') .
                                        $this->MapMarker('provider_latitude', 'provider_longitude') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('ساعات کاری') .
                                        $this->WorkingHours(2) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->providerAttrsFormat() .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->providerGalleryFormat() .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    private function providerAttrsFormat()
    {
        return HtmlTags::Div('.card.card-warning.card-outline.w-100')->Content(
            HtmlTags::Div('.card-header.p-3')->Content(
                HtmlTags::Span('.card-title.small')->Content(
                    HtmlTags::I()->Class(FontAwesome::Money())->Class('ml-2'),
                    "ویژگی های پذیرنده"
                ),
                HtmlTags::Div('.card-tools#addAttributeBtn')->Content(
                    HtmlTags::Button('.btn.btn-success.p-2')->Content(
                        HtmlTags::I()->Class(FontAwesome::Plus())
                    )->Type("button"),
                ),
            ),
            HtmlTags::Div('.card-body.w-100.d-flex.flex-wrap.mt-3')->Content(
                $this->providerAttrs(),
            )
        );

    }

    private function providerAttrs()
    {
        $attributes = collect([]);
        $provider_id = @$this->getData()->provider_id;
        if ($provider_id > 0) {
            $provider = \model\Providers::get($provider_id);
            $attributeIds = json_decode($provider->attribute_ids, true);

            if (is_array($attributeIds) && count($attributeIds) > 0) {
                $attributes = collect($attributeIds)->map(function ($id) {
                    return \model\Attributes::get($id);
                })->filter(fn($item) => $item !== null);
            }
        }

        return HtmlTags::Table('.table.table-bordered')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content("نام ویژگی"),
                    HtmlTags::Th()->Content("مقدار ویژگی"),
                    HtmlTags::Th()->Content("عملیات")
                )
            ),
            HtmlTags::Tbody("#attributeTable")->Content(
                function () use ($attributes) {
                    return $attributes->map(function ($attr, $index) {
                        $rowId = "attribute_row_" . uniqid();
                        return HtmlTags::Tr()->Id($rowId)->Content(
                            HtmlTags::Td()->Content(
                                HtmlTags::Input()
                                    ->Name("attributes[$index][name]")
                                    ->Value($attr->name)
                                    ->Class("form-control")
                                    ->Required()
                            ),
                            HtmlTags::Td()->Content(
                                HtmlTags::Input()
                                    ->Name("attributes[$index][value]")
                                    ->Value($attr->value)
                                    ->Class("form-control")
                                    ->Required()
                            ),
                            HtmlTags::Td()->Content(
                                HtmlTags::Button('.btn.btn-danger.p-2.deleteAttributeRow')->Content(
                                    HtmlTags::I()->Class(FontAwesome::Trash())
                                )->Data_('id', $rowId)->Type('button')
                            )
                        );
                    })->join('');
                }
            ),
            HtmlTags::Tfoot()
        );
    }

    private function providerGalleryFormat()
    {
        return HtmlTags::Div('.card.card-warning.card-outline.w-100')->Content(
            HtmlTags::Div('.card-header.p-3')->Content(
                HtmlTags::Span('.card-title.small')->Content(
                    HtmlTags::I()->Class(FontAwesome::File_image_o())->Class('ml-2'),
                    "گالری پذیرنده"
                ),
                HtmlTags::Div('.card-tools#addGallaryBtn')->Content(
                    HtmlTags::Button('.btn.btn-success.p-2')->Content(
                        HtmlTags::I()->Class(FontAwesome::Plus())
                    )->Type("button"),
                ),
            ),
            HtmlTags::Div('.card-body.w-100.d-flex.flex-wrap.mt-3')->Content(
                $this->providerGalleries(),
            )
        );

    }

    private function providerGalleries()
    {
        $images = collect([]);
        $provider_id = @$this->getData()->provider_id;

        if ($provider_id > 0) {
            $images = \model\ProviderGalleries::getAllFiltered('provider_id', $provider_id);
        }

        return HtmlTags::Table('.table.table-bordered')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Content("پیش ‌نمایش تصویر"),
                    HtmlTags::Th()->Content("عملیات")
                )
            ),
            HtmlTags::Tbody("#galleryTable")->Content(
                function () use ($images) {
                    return $images->map(function ($image, $index) {
                        $rowId = "gallery_row_" . uniqid();
                        $src = __IMAGES__ . "ProviderGalleries/" . $image->provider_image;
                        return HtmlTags::Tr()->Id($rowId)->Content(
                            HtmlTags::Td()->Content(
//                                HtmlTags::Img(".previewMe")
//                                    ->Src(__IMAGES__."ProviderGalleries/".$image->provider_image)
//                                    ->Width("150")->Height("150")
                                "<img class='previewMe providerGalleryImage' alt='خطا در نمایش تصویر' src='$src' width='150' height='150'>"

                            ),
                            HtmlTags::Td()->Content(
                                HtmlTags::Button('.btn.btn-danger.p-2.deleteGalleryRow')->Content(
                                    HtmlTags::I()->Class(FontAwesome::Trash())
                                )->Data_('id', $rowId)->Data_('image', $image->provider_image)->Type('button')
                            ),
                            // hidden برای اینکه آدرس عکس فراموش نشه
                            HtmlTags::Input()
                                ->Type('hidden')
                                ->Name("gallery_images[$index][url]")
                                ->Value($image->provider_image)
                        );
                    })->join('');
                }
            ),
            HtmlTags::Tfoot()
        );
    }


    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    private function WorkingHours(int $int = 3): \FwHtml\Elements\Tags\Table
    {
        $int = ($int > 4 ? 4 : $int <= 0) ? 1 : $int;
        $times = [
            'morning' => 'صبح',
            //'noon' => 'ظهر',
            'afternoon' => 'بعد از ظهر',
        ];
        $output = [];
        $shifts = [];
        $startAndEnds = [];
        $t = array_values($times);
        for ($i = 0; $i < $int; $i++) {
            $shifts[] = HtmlTags::Th()->Content(
                $t[$i]
            )->Attrs(['colspan' => 3]);
            $startAndEnds[] = HtmlTags::Th()->Content(
                "وضعیت"
            );
            $startAndEnds[] = HtmlTags::Th()->Content(
                "شروع"
            );
            $startAndEnds[] = HtmlTags::Th()->Content(
                "پایان"
            );
        }
        $editShifts = @json_decode(@$this->getData()->provider_work_hours, true) ?? [];
        foreach (DayHelper::toArray() as $dayName => $day) {
            $output[] = HtmlTags::Tr()->Content(
                HtmlTags::Td()->Content(
                    $day
                ),
                function () use ($int, $day, $dayName, $times, $editShifts) {
                    $output = [];
                    $time = array_keys($times);
                    for ($i = 0; $i < $int; $i++) {

                        $output[] = HtmlTags::Td()->Content(
                            HtmlTags::Input('.workHourCheckbox')
                                ->Attrs(['checked' => @isset($editShifts[$dayName][$time[$i]])])
                                ->Type('checkbox')->Name("time_data[checkbox][$dayName][]")->Value($time[$i])
                        );
                        $output[] = HtmlTags::Td()->Content(
                            $this->Html()->Time("time_data[dayInfo][$dayName][$time[$i]][start]")
                                ->Disabled(@!isset($editShifts[$dayName][$time[$i]]))->Data_('shift', $time[$i])->Required(false)
                                ->Value(($editShifts and @$editShifts[$dayName] and @$editShifts[$dayName][$time[$i]]) ? "{$editShifts[$dayName][$time[$i]]['start']}" : '')
                        );
                        $output[] = HtmlTags::Td()->Content(
                            $this->Html()->
                            Time("time_data[dayInfo][$dayName][$time[$i]][end]")
                                ->Disabled(!isset($editShifts[$dayName][$time[$i]]))
                                ->Data_('shift', $time[$i])->Required(false)
                                ->Value(($editShifts) ? @$editShifts[$dayName][$time[$i]]['end'] ?? "" : '')
                        );
                    }
                    return $output;
                }
            );
        }
        $this->initDataTable = false;
        return HtmlTags::Table('.table.table-striped.table-bordered.daytime')->Content(
            HtmlTags::Thead()->Content(
                HtmlTags::Tr()->Content(
                    HtmlTags::Th()->Attrs(['rowspan' => 2])->Content(
                        "#"
                    ),
                    $shifts
                ),
                HtmlTags::Tr()->Content(
                //					HtmlTags::Th(),
                    $startAndEnds
                )
            ),
            HtmlTags::Tbody()->Content(
                $output
            )
        );
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        