$(function () {


    $("#state_id").on('change', function () {
        let id = $(this).val()
        $.ajax({
            url: "controllers/BaseTables/Locations/Cities/Cities",
            type: "POST",
            data: {
                controller_type: "getCities",
                id
            },
            success: res => {
                $("#city_id").attr('disabled', false)
                $("#city_id").html(res)
            }
        });

    })

    $("#city_id").on('change', function () {
        let id = $(this).val()
        $.ajax({
            url: "controllers/BaseTables/Locations/Regions/Regions",
            type: "POST",
            data: {
                controller_type: "getRegions",
                id
            },
            success: res => {
                $("#region_id").attr('disabled', false)
                $("#region_id").html(res)
            }
        });

    })
    $.checkCheckBox();
    $(".workHourCheckbox").on('ifChecked', function () {
        let tr = $(this).parents('tr'), value = $(this).val();
        $(tr).find(`input.form-control[data-shift=${value}]`).attr('disabled', false).attr('required', true)
    });
    $(".workHourCheckbox").on('ifUnchecked', function () {
        let tr = $(this).parents('tr'), value = $(this).val();
        const input = $(tr).find(`input.form-control[data-shift=${value}]`);
        $(input).attr('disabled', true).attr('required', false).val('')
        if ($(tr).find('td').filter(function() {
            return $(this).text().trim() === 'شنبه';
        }).length > 0) {
            copy(input);
        }
    });


    function isIChecked(checkbox) {
        // اگر iCheck روی چک‌باکس فعال باشه
        if (checkbox.parent().hasClass('icheckbox_square-blue') || checkbox.parent().hasClass('icheckbox_minimal-blue')) {
            return checkbox.parent().hasClass('checked');
        } else {
            return checkbox.is(':checked');
        }
    }


    let isSyncing = false;


    //
    // $('tr:has(td:contains("شنبه")) input[data-shift]').on('input change', function () {
    //     copySaturdayValuesToOthers();
    // });

    $('tr').filter(function () {
        return $(this).find('td').filter(function () {
            return $(this).text().trim() === 'شنبه';
        }).length > 0;
    }).find('input.timeDropper').on('input change', function () {
        console.log('event');
        copy(this);
    });

    const copy = (that) => {
        if (isSyncing) return; // ← جلوگیری از لوپ
        isSyncing = true;
        setTimeout(()=>{
            const shift = $(that).data('shift');
            const startVal = $(that).parents('tr').find(`input[data-shift=${shift}][name*="[start]"]`).val();
            const endVal = $(that).parents('tr').find(`input[data-shift=${shift}][name*="[end]"]`).val();
            const checkbox = $(that).parents('tr').find(`.workHourCheckbox[value=${shift}]`).first();
            const isChecked = isIChecked(checkbox);
            $('tr').each(function () {
                const dayText = $(this).find('td:first').text().trim();
                if (dayText !== 'شنبه') {
                    const startInput = $(this).find(`input[data-shift=${shift}][name*="[start]"]`);
                    const endInput = $(this).find(`input[data-shift=${shift}][name*="[end]"]`);
                    const checkbox = $(this).find(`.workHourCheckbox[value=${shift}]`).first();
                    const isCheckBoxChecked = isIChecked(checkbox);
                    startInput.attr('disabled',!isCheckBoxChecked).val(startVal)
                    endInput.attr('disabled',!isCheckBoxChecked).val(endVal)

                    if (checkbox.length) {
                        if (isChecked) {
                            checkbox.iCheck ? checkbox.iCheck('check') : checkbox.prop('checked', true)
                        } else {
                            checkbox.iCheck ? checkbox.iCheck('uncheck').trigger('ifUnchecked') : checkbox.prop('checked', false)
                        }
                    }

                }
            });
            isSyncing = false;
        },500)
    }

})