<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Comments extends View
{

    public $SingularName = 'نظر';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کاربر'),
                                                                    HtmlTags::Th('پذیرنده'),
                                                                    HtmlTags::Th('نظر'),
                                                                    HtmlTags::Th('وضعیت ناشناس'),
                                                                    HtmlTags::Th('تعداد ستاره'),
                                                                    HtmlTags::Th('وضعیت نمایش'),
                                                                    HtmlTags::Th('وضعیت تایید'),
                                                                    HtmlTags::Th('تاریخ'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'user_id' => function ($item) {
                                                                        $user = \model\Users::get($item);
                                                                        return $item == 0 ? "کامنت ادمین" : $user->user_name . " (" . $user->user_mobile . ")";
                                                                    },
                                                                    'provider_id' => function ($item) {
                                                                        return \model\Providers::get($item)->provider_name;
                                                                    },
                                                                    'comment',
                                                                    'anonymous' => function ($row) {
                                                                        return $row == 1 ? "بدون نام" : "با نام";
                                                                    },
                                                                    'rate' => function ($rate) {
                                                                        switch ($rate) {
                                                                            case 1:
                                                                                return "⭐";
                                                                                break;
                                                                            case 2:
                                                                                return "⭐⭐";
                                                                                break;
                                                                            case 3;
                                                                                return "⭐⭐⭐";
                                                                                break;
                                                                            case 4:
                                                                                return "⭐⭐⭐⭐";
                                                                                break;
                                                                            case 5:
                                                                                return "⭐⭐⭐⭐⭐";
                                                                                break;

                                                                        }
                                                                    },
                                                                    'status' => function ($status) {
                                                                        return $status == 1 ? "منتشر شده" : 'پنهان شده';
                                                                    },
                                                                    'confirm_status' => function ($status) {
                                                                        return $status == 1 ? "تایید شده" : 'بررسی نشده';
                                                                    },
                                                                    'created_at' => function ($created) {
                                                                        return jdate("Y/m/d H:i", strtotime($created));
                                                                    }
                                                                ], true, false, false, false, function ($row) {
                                                                    if ($row->status == 1) {
                                                                        return HtmlTags::A('.btn.btn-outline-danger.p-2.changeCommentStatus')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('status', '0')
                                                                            ->Data_('id', $row->comment_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('عدم نمایش');
                                                                    } else {
                                                                        return HtmlTags::A('.btn.btn-outline-success.p-2.changeCommentStatus')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('status', '1')
                                                                            ->Data_('id', $row->comment_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('نمایش');
                                                                    }

                                                                }, function ($row) {
                                                                    if ($row->confirm_status == 1) {
                                                                        return HtmlTags::A('.btn.btn-danger.p-2.changeCommentConfirmStatus')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('status', '0')
                                                                            ->Data_('id', $row->comment_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('عدم تایید');
                                                                    } else {
                                                                        return HtmlTags::A('.btn.btn-success.p-2.changeCommentConfirmStatus')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('status', '1')
                                                                            ->Data_('id', $row->comment_id)
                                                                            ->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('تایید نظر');
                                                                    }

                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .


                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('پذیرنده') .
                                        $this->Html()->Select('provider_id', 'provider_id', \model\Providers::toOption()) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('امتیاز (1 تا 5)') .
                                        $this->Html()->Float('rate', 1, 5) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('نظر') .
                                        $this->Html()->Input('comment') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        