<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Codes extends View
{

    public $SingularName = 'کد';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('کد'),
                                                                    HtmlTags::Th('اشتراک'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show(['code','plan_id'=>function ($id) {
                                                                    return \model\Plans::get($id)->name;
                                                                },function ($row) {
                                                                    if ($row->user_id){
                                                                        $res = show_user_name($row->user_id);
                                                                        return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                            $res
                                                                        );
                                                                    }else{
                                                                        return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                            "استفاده نشده"
                                                                        );
                                                                    }
                                                                }], true, false,
                                                                    false, false, function ($row) {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.editCode')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Edit())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('ویرایش'),
                                                                        )->Data_('id', $row->plan_id)->Data_('status', '-1');
                                                                    })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack(),
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('حالت : افزودن کد کارت به صورت دستی <br> (کد کارت مد نظرتان را در ورودی زیر وارد کنید)', '', 'aniCodeLabel') .
                                        $this->Html()->Input('codeNumber', 'codeNumber')->PlaceHolder("مثال : AgDri3")->Type("text") .

                                        HtmlTags::Button('.btn.btn-warning.p-2#addCustomizedAniCode')->Content(
                                            'افزودن کد تصادفی'
                                        )->Data_('type', 'random')->Type("button") .

                                        HtmlTags::Input()
                                            ->Type('hidden')
                                            ->Name("aniCodeType")
                                            ->Id("aniCodeType")
                                            ->Value('custom') .

                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart().
                                        $this->Html()->Label('انتخاب اشتراک <br>  ').
                                        $this->Html()->Select('plan_id','plan_id',\model\Plans::toOption()).
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function Inperson(Document $document)
    {
        $planOptions = \model\Plans::toOption();

        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                                                      ->Content(
                                                          HtmlTags::Div('.row')
                                                                  ->Content(
                                                                      HtmlTags::Div('.col-md-12')->Content(
                                                                          HtmlTags::Div('.card.card-primary.card-outline')
                                                                                  ->Content(
                                                                                      HtmlTags::Div('.card-header')
                                                                                              ->Content(
                                                                                                  $this->Html()->CardTitle('فروش حضوری کدهای آنی کارت'),
                                                                                                  $this->Html()->refreshAndBack()
                                                                                              ),
                                                                                      $this->Html()->FormStart() .
                                                                                      controllerType('submitInperson').

                                                                                      HtmlTags::Div('.row.d-flex.flex-wrap.w-100')->Content(
                                                                                              $this->Html()->FormGroupStart(3) .
                                                                                              $this->Html()->Label('تعداد کد') .
                                                                                              $this->Html()->Number('code_count', 'code_count').
                                                                                              $this->Html()->FormGroupEnd().
                                                                                              $this->Html()->FormGroupStart(3) .
                                                                                              $this->Html()->Label('نوع اشتراک (برای همه)') .
                                                                                              $this->Html()->Select('global_plan_id', 'global_plan_id', $planOptions) .
                                                                                              $this->Html()->FormGroupEnd().
                                                                                              $this->Html()->FormGroupStart(3) .
                                                                                              $this->Html()->Label('تاریخ انقضا (برای همه)') .
                                                                                              $this->Html()->PersianDate('global_expire_date', 'global_expire_date') .
                                                                                              $this->Html()->FormGroupEnd().
                                                                                              $this->Html()->FormGroupStart(3) .
                                                                                              $this->Html()->Label('کد معرف (برای همه)') .
                                                                                              $this->Html()->Input('global_referral_code', 'global_referral_code')->PlaceHolder('اختیاری')->Required(false) .
                                                                                              $this->Html()->FormGroupEnd()
                                                                                          ).

                                                                                      HtmlTags::Hr() .

                                                                                      HtmlTags::Div('.w-100#generated_codes_table') . // جدول در JS ساخته می‌شود


                                                                                      $this->Html()->CardFooter("",false,HtmlTags::Div('.d-flex.gap-2')->Content(
                                                                                          HtmlTags::Div('.form-group.col-md-6')->Content(
                                                                                              HtmlTags::Button('.btn.btn-success.btn-block#generate_codes')->Content('تولید کدها')->Type('button')
                                                                                          ) .

                                                                                          HtmlTags::Div('.form-group.col-md-6')->Content(
                                                                                              HtmlTags::Button('.btn.btn-primary.btn-block#submit_codes')->Content('ثبت نهایی')->Type('submit')
                                                                                          )

                                                                                      ))
                                                                                  )
                                                                                  )
                                                                      )

                                                      );
    }


    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        