<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class WithdrawRequestsMigration extends Migratable {
    const modelName = 'WithdrawRequests';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('withdraw_request_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->VarChar('request_amount')->Len(150);
			$blueprint->VarChar('request_sheba')->Len(150);
			$blueprint->VarChar('request_status')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
