<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class DateTimesMigration extends Migratable {
    const modelName = 'DateTimes';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('date_time_id');
			$blueprint->Int('service_id')->Len(150);
			$blueprint->Int('date_time_duration')->Len(150);
			$blueprint->Int('date_time_frequency')->Len(150);
			$blueprint->Int('date_time_discount')->Len(150);
			$blueprint->Text('date_time_details');
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
