<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class UserAddressesMigration extends Migratable {
    const modelName = 'UserAddresses';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('user_addresse_id');
			$blueprint->VarChar('user_address_name')->Len(150);
			$blueprint->Text('user_address_text');
			$blueprint->VarChar('user_address_floor')->Len(150);
			$blueprint->VarChar('user_address_zip_code')->Len(150);
			$blueprint->VarChar('user_address_phone')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
